#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Modified MandalaMod01.fsh   by   taellinglin
//https://www.shadertoy.com/view/....
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.141592
#define TAU 2.0*PI


void amod(inout vec2 p, float c) {
    float m = TAU / c;
    float a = mod(atan(p.x, p.y)-m*.5, m) - m*.5;
    p = vec2(cos(a), sin(a)) * length(p);
}

void mo(inout vec2 p, vec2 d) {
    p = abs(p) - d;
    if(p.y>p.x)p=p.yx;
}

mat2 r2d(float a) {
    float c = cos(a), s = sin(a);
    return mat2(c, s, -s, c);
}

float smooth_stairs(float x) {
    return tanh(5.*(x-floor(x)-0.5))/tanh(2.5)*0.5+floor(x)+0.5;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = ( fragCoord - .5*iResolution.xy ) / iResolution.y;
    //vec2 mouse = iMouse.xy / iResolution.xy;
    uv.y = abs(uv.y);
    
    uv *= 3.0;
    //amod(uv, 5.5+sin(iTime*0.2)*2.5);
    float nrays = abs(mod(iTime*0.3, 10.)-5.);
    amod(uv, 8.-smooth_stairs(nrays));
    
    mo(uv, vec2(1.2+sin(iTime*0.3), 0.6+sin(iTime*0.5)*0.3));
    uv *= r2d(PI/12.-PI/8.*mod(iTime*0.2, 16.));
    mo(uv, vec2(1.1+sin(iTime*0.5)*0.7, 0.4+0.5*1.5));
    uv *= r2d(PI/6.-mod(iTime*0.25, 12.0)*PI/6.0);
    mo(uv, vec2(.7+sin(iTime*0.45)*0.2, .2));
    
    //uv *= 10.;
    uv *= 30.;
    //float l = min(abs(uv.x), abs(uv.y));
    //float l = max(abs(uv.x), abs(uv.y));
    float l = abs(uv.x) + abs(uv.y);
    float d = sin(l) - .3;
    
    d = smoothstep(0., fwidth(d), d);
    fragColor = vec4(sqrt(d),sqrt(d),sqrt(d),0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

